using System;
using System.Data;
using System.Data.SqlClient;
using gov.va.med.vbecs.ExceptionManagement;
using STOREDPROC = gov.va.med.vbecs.Common.VbecsStoredProcs;

namespace gov.va.med.vbecs.DAL
{
    #region Header
	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> 
	///WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified
	///</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>John Vrooland</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>6/13/2003</CreationDate>
	///<Note>
	///The Food and Drug Administration classifies this software as a medical device.  
	///As such, it may not be changed in any way. Modifications to this software may result 
	///in an adulterated medical device under 21CFR820, the use of which is considered to 
	///be a violation of US Federal Statutes.  Acquiring and implementing this software through 
	///the Freedom of information Act requires the implementor to assume total responsibility 
	///for the software, and become a registered manufacturer of a medical device, subject 
	///to FDA regulations
	///</Note>
	///<summary>
	/// Data access component implementing data persistence logic for patient 
	/// specimen related data
	///</summary>
    #endregion

	public class PatientSpecimen
	{

		///<Developers>
		///	<Developer>Carl Jensen</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>4/17/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2145"> 
		///		<ExpectedInput>Valid PatientGuid</ExpectedInput>
		///		<ExpectedOutput>DataTable</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2146"> 
		///		<ExpectedInput>Invalid Guid</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///<summary>
		///	Retrieves specimen expiration date for a specified patient 
		///</summary>
		///<param name="patientGuid">Patient GUID</param>
		///<returns>DataTable containing patient GUID and a specimen expiration date</returns>
		public static DataTable ValidSpecimenExists( System.Guid patientGuid )
		{
			SqlParameter[] prms =
			{
				new SqlParameter(STOREDPROC.ValidSpecimenExists.patientguid, SqlDbType.UniqueIdentifier),
				new SqlParameter(STOREDPROC.ValidSpecimenExists.divisioncode, SqlDbType.VarChar)
			};
            
			prms[0].Value = patientGuid;
			prms[1].Value = Common.LogonUser.LogonUserDivisionCode;

			return Common.StoredProcedure.GetData(STOREDPROC.ValidSpecimenExists.StoredProcName, prms).Tables[0];
		}
	}
}